<?php
header('Content-Type: text/plain');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: Content-Type');
header('Access-Control-Allow-Methods: POST, OPTIONS');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') { http_response_code(200); exit; }

$data = json_decode(file_get_contents('php://input'), true);
$id    = $data['id']    ?? '';
$name  = $data['name']  ?? 'file.dat';
$path  = trim($data['path'] ?? '');

if (!$id) { http_response_code(400); exit('Missing file ID'); }

$path = preg_replace('~^/+|/+$~', '', $path);
$path = preg_replace('~[^-_.@/a-zA-Z0-9 ]~', '', $path);

$chunksDir = __DIR__.'/uploads/chunks'.($path ? '/'.$path : '');
$finalDir  = __DIR__.'/files'.($path ? '/'.$path : '');
$logDir    = __DIR__.'/uploads/log'.($path ? '/'.$path : '');

foreach ([$finalDir, $logDir] as $dir) {
    if (!is_dir($dir) && !mkdir($dir, 0777, true)) {
        http_response_code(500);
        exit("Failed to create directory: $dir");
    }
}

// --- load manifest ---
$manifestFile = $chunksDir."/{$id}_manifest.json";
$total = 0;
if (file_exists($manifestFile)) {
    $manifest = json_decode(file_get_contents($manifestFile), true);
    $total    = $manifest['total'] ?? 0;
}

// collect chunks
$files = glob("$chunksDir/{$id}_*");
$files = array_filter($files, fn($f) => strpos($f, "_manifest.json") === false);
usort($files, fn($a,$b) => intval(substr(strrchr($a,'_'),1)) - intval(substr(strrchr($b,'_'),1)));

// verify completeness
if ($total > 0 && count($files) < $total) {
    http_response_code(409);
    exit("Not all chunks uploaded: received ".count($files)." / $total");
}

// ensure unique filename
$ext       = pathinfo($name, PATHINFO_EXTENSION);
$base      = pathinfo($name, PATHINFO_FILENAME);
$finalName = $name;
$counter   = 1;

while (file_exists($finalDir.'/'.$finalName)) {
    $finalName = $base.$counter.($ext ? '.'.$ext : '');
    $counter++;
}
$outFile = $finalDir.'/'.$finalName;

// assemble chunks
$out = fopen($outFile, 'wb');
if (!$out) { http_response_code(500); exit("Cannot create output file"); }

foreach ($files as $f) {
    $in = fopen($f, 'rb');
    if ($in) {
        stream_copy_to_stream($in, $out);
        fclose($in);
        unlink($f);
    }
}
fclose($out);
@unlink($manifestFile);
@rmdir($chunksDir);
// 🧹 CLEANUP - Remove the chunks directory
//cleanupChunksDirectory($chunksDir);
$meta = [
    'id'          => $id,
    'original'    => $name,
    'saved_as'    => $finalName,
    'path'        => $path,
    'size'        => filesize($outFile),
    'upload_time' => time(),
    'status'      => 'complete'
];
$logFile = $logDir.'/'.$id.'.json';
file_put_contents($logFile, json_encode($meta, JSON_PRETTY_PRINT));
touch(__DIR__.'/last_change.flag');
echo "OK";