<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: Content-Type, X-Requested-With, Authorization');
header('Access-Control-Allow-Methods: POST, GET, OPTIONS, DELETE, PUT');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') { http_response_code(200); exit; }

// --- GET: resume / manifest check ---
if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    $id   = $_GET['id']  ?? '';
    $path = trim($_GET['path'] ?? '');
    $manifestQuery = isset($_GET['manifest']);

    $path = preg_replace('~^/+|/+$~','',$path);
    $path = preg_replace('~[^-_.@/a-zA-Z0-9 ]~','',$path);

    $chunksDir = __DIR__."/uploads/chunks".($path ? "/$path" : "");
    $manifestFile = "$chunksDir/{$id}_manifest.json";

    if ($manifestQuery) {
        if (file_exists($manifestFile)) {
            header('Content-Type: application/json');
            echo file_get_contents($manifestFile);
        } else {
            echo json_encode(["received"=>[],"total"=>0]);
        }
        exit;
    }

    $idx  = (int)($_GET['idx'] ?? 0);
    $chunkFile = "$chunksDir/{$id}_$idx";

    if (file_exists($chunkFile) && filesize($chunkFile) > 0) {
        echo "EXISTS";
    } else {
        echo "MISSING";
    }
    exit;
}

// --- POST: handle chunk upload ---
if (empty($_FILES['chunk']['tmp_name']) || !is_uploaded_file($_FILES['chunk']['tmp_name'])) {
    http_response_code(400);
    exit('No chunk received or invalid upload');
}

$id    = $_POST['id']    ?? '';
$idx   = (int)($_POST['idx'] ?? 0);
$path  = trim($_POST['path'] ?? '');
$total = (int)($_POST['total'] ?? 0);

if (empty($id)) { http_response_code(400); exit('Missing file ID'); }

$path = preg_replace('~^/+|/+$~','',$path);
$path = preg_replace('~[^-_.@/a-zA-Z0-9 ]~','',$path);

$base = __DIR__.'/uploads/chunks';
if ($path !== '') $base .= '/'.$path;
if (!is_dir($base) && !mkdir($base, 0777, true)) {
    http_response_code(500);
    exit('Failed to create chunk directory');
}

$out = "$base/{$id}_$idx";

// save chunk
if (move_uploaded_file($_FILES['chunk']['tmp_name'], $out)) {
    if (filesize($out) > 0) {
        $manifest = $base."/{$id}_manifest.json";
        $data = file_exists($manifest) ? json_decode(file_get_contents($manifest), true) : [
            "id"       => $id,
            "total"    => $total,
            "received" => [],
            "path"     => $path
        ];
        if ($total > 0) $data["total"] = $total;
        if (!in_array($idx, $data['received'])) $data['received'][] = $idx;

        // Sort received chunks for easier resume
        sort($data['received'], SORT_NUMERIC);

        file_put_contents($manifest, json_encode($data, JSON_PRETTY_PRINT));
        echo 'OK';
    } else {
        http_response_code(500);
        echo 'Chunk save verification failed';
    }
} else {
    http_response_code(500);
    echo 'Error saving chunk';
    error_log("Chunk upload failed for ID: $id, Index: $idx, Error: ".$_FILES['chunk']['error']);
}
