<?php
// sse.php
header('Content-Type: text/event-stream');
header('Cache-Control: no-cache');
header('Access-Control-Allow-Origin: *');

$watchFile = __DIR__.'/last_change.flag';   // touched by every upload
$last = isset($_SERVER['HTTP_LAST_EVENT_ID']) ? intval($_SERVER['HTTP_LAST_EVENT_ID']) : 0;

while (true) {
    clearstatcache();
    if (is_file($watchFile) && filemtime($watchFile) > $last) {
        $now = filemtime($watchFile);
        echo "id: $now\n";
        echo "event: folder-change\n";
        echo "data: ".json_encode(['path' => dirname($watchFile)])."\n\n";
        flush();
        $last = $now;
    }
    sleep(1);          // 1 s heartbeat is fine for file-manager use
}
?>